# check cmd args

if (scalar(@ARGV) < 1) {
    die "Arguments: <new files file name> [<areamask>:<file>]+\n";
}

# keep area:file pairs

for ($i = 1; $i < scalar(@ARGV); $i++) {
    @parts = split(/\:/,$ARGV[$i]);
    $area = uc $parts[0];
    $file = "";
    for ($j = 1; $j < scalar(@parts); $j++) {
        if ($j == 1) {
            $file = $parts[$j];
        }
        else {
            $file .= ":".$parts[$j];
        }
    }
    $areafiles{$area} = $file;
}

# read data

open( NEWFILES, $ARGV[0] ) || die("Failed to open $ARGV[0] for reading\n");
$line = <NEWFILES>;
chop($line);
while ($line ne "") {

    # area

    if (!($line =~ /^Area\s/)) {
        break;
    }
    $area = uc substr( $line, 5 );

    # file

    $line = <NEWFILES>;
    chop($line);
    if (!($line =~ /^File\s/)) {
        break;
    }
    $file = substr( $line, 5 );

    # size

    $line = <NEWFILES>;
    chop($line);
    if (!($line =~ /^Size\s/)) {
        break;
    }
    $size = substr( $line, 5 );

    # desc

    $line = <NEWFILES>;
    chop($line);
    if (!($line =~ /^Desc\s/)) {
        break;
    }
    $desc = substr( $line, 5 );
    # replace russian  with english H
    $desc =~ tr//H/;

    # origin

    $line = <NEWFILES>;
    chop($line);
    if (!($line =~ /^Origin\s/)) {
        break;
    }
    $origin = substr( $line, 7 );

    # uplink

    $line = <NEWFILES>;
    chop($line);
    if (!($line =~ /^Uplink\s/)) {
        break;
    }
    $uplink = substr( $line, 7 );

    # keep data

    $areas{$area}{$file} = \@{[$size, $desc, $origin, $uplink]};

    # read next line
    $line = <NEWFILES>;
    chop($line);
}
close( NEWFILES );

# remove NEWFILES

system( ("del", "$ARGV[0]") );

# do output

$curfile = "";

foreach $area (sort keys %areas) {

    # check output file
    $outfile = "";
    foreach $areamask (keys %areafiles) {
        if ($area =~ /$areamask/) {
            $outfile = $areafiles{$areamask};
            break;
        }
    }
    if ($outfile eq "") {
        if ($curfile ne $ARGV[0]) {
            if ($curfile ne "") {
                close(OUT);
            }
            $curfile = $ARGV[0];
            open( OUT, ">>$curfile" ) || die("Failed to open $curfile for appending.\n");
        }
    }
    elsif ($outfile ne $curfile) {
            if ($curfile ne "") {
                close(OUT);
            }
            $curfile = $outfile;
            open( OUT, ">>$curfile" ) || die("Failed to open $curfile for appending.\n");
    }

    # prepare area title

        open( OUT, ">>$curfile" ) || die( "Failed to open $curfile for writing.\n");
        
        print OUT "\n";
        
    $title = "> ".$area." ";
    $fill_len = 78 - length( $title );
    while ($fill_len > 0) {
        $title = $title."";
        $fill_len = $fill_len - 1;
    }

    # print title

    print OUT "$title\n";

    $n_files = 0;
    $n_size  = 0;
    $fileref = $areas{$area};

    # we need special processing for BOOK
    if ($area eq "BOOK") {

        foreach $file (sort keys %$fileref) {
            # retrieve all data
            $size   = $$fileref{$file}[0];
            $desc   = $$fileref{$file}[1];
            $origin = $$fileref{$file}[2];
            $uplink = $$fileref{$file}[3];

            # get author
            @descParts = split /\.\s/, $desc;
            if (@descParts > 1) {
                $author = $descParts[0];
                $desc   = substr( $desc, length($author)+2 );
            }
            else {
                $author = $desc;
            }

            $authors{$author}{$file} = \@{[$size, $desc, $origin, $uplink]};
        }    

        # print files per author

        foreach $author (sort keys %authors) {

            print OUT "\n$author\n\n";

            $fileref = $authors{$author};

            # print files

            foreach $file (sort keys %$fileref) {

                # increase files number
                $n_files = $n_files + 1;
                # get file size
                $size    = $$fileref{$file}[0];
                $n_size  = $n_size + $size;
                # print file name and file size
                $size = &formatsize($size);
                if (length( $file ) > 12) {
                    $fileline = sprintf( "  %s\n               %10s ", $file, $size );
                }
                else {
                    $fileline = sprintf( "  %-12s %10s ", $file, $size );
                }
                print OUT $fileline;
                # print description
                @desclist = split( /\s/, $$fileref{$file}[1] );
                $desc  = "";
                $first = 1;
                foreach $word (@desclist) {
                    if (length($desc) + length($word) < 53) {
                        if (length($desc) == 0) {
                            $desc = $word;
                        }
                        else {
                            $desc = $desc." ".$word;
                        }
                    }
                    else {
                        if (length($word) > 53) {
                            if (length($desc) == 0) {
                                $desc = substr($word, 0, 52 - length($desc));
                            }
                            else {
                                $desc = $desc." ".substr($word, 0, 52 - length($desc));
                            }
                            $word = substr( $word, 52 - length($desc) );
                        }
                        if ($first) {
                            $first = 0;
                        }
                        else {
                            print OUT "                          ";
                        }
                        print OUT "$desc\n";
                        $desc = $word;
                    }
                }
                    if (!$first) {
                        print OUT "                          ";
                    }
                print OUT "$desc\n";

                # print origin address

                $origin = $$fileref{$file}[2];
                $origin =~ s/^2\:5023\///;
                        print OUT "                           $origin\n";
            }
        }
    }
    else {

        # print files

        foreach $file (sort keys %$fileref) {
            # increase files number
            $n_files = $n_files + 1;
            # get file size
            $size    = $$fileref{$file}[0];
            $n_size  = $n_size + $size;
            # print file name and file size
            $size = &formatsize($size);
            if (length( $file ) > 12) {
                $fileline = sprintf( "  %s\n               %10s ", $file, $size );
            }
            else {
                $fileline = sprintf( "  %-12s %10s ", $file, $size );
            }
            print OUT $fileline;
            # print description
            @desclist = split( /\s/, $$fileref{$file}[1] );
            $desc  = "";
            $first = 1;
            foreach $word (@desclist) {
                if (length($desc) + length($word) < 53) {
                    if (length($desc) == 0) {
                        $desc = $word;
                    }
                    else {
                        $desc = $desc." ".$word;
                    }
                }
                else {
                    if (length($word) > 53) {
                        if (length($desc) == 0) {
                            $desc = substr($word, 0, 52 - length($desc));
                        }
                        else {
                            $desc = $desc." ".substr($word, 0, 52 - length($desc));
                        }
                        $word = substr( $word, 52 - length($desc) );
                    }
                    if ($first) {
                        $first = 0;
                    }
                    else {
                        print OUT "                          ";
                    }
                    print OUT "$desc\n";
                    $desc = $word;
                }
            }
                if (!$first) {
                    print OUT "                          ";
                }
            print OUT "$desc\n";

            # print origin address

            $origin = $$fileref{$file}[2];
            $origin =~ s/^2\:5023\///;
                    print OUT "                           $origin\n";
        }
    }

    $TotalFiles{$curfile} += $n_files;
    $TotalSize{$curfile}  += $n_size;

    # print tail
    print OUT ">\n";   
    $n_size = &formatsize( $n_size );
    print OUT "Total: $n_files file(s) of $n_size byte(s)\n\n";
}

close(OUT);

# print total files number and total size in every created file

foreach $file (keys %TotalFiles) {
        open( OUT, ">>$file" ) || die("Failed to open $file for appending.\n");
    
        print OUT "\nTotal files number: $TotalFiles{$file}\n";
        $n_size_total = &formatsize($TotalSize{$file});
        print OUT "Total files size:   $n_size_total byte(s)\n\n";

        close( OUT );
}

sub formatsize {
    my($size) = $_[0];
    my($len)  = length( $size );
    @letters = split( / */, reverse($size) );
    my($count) = 0;
    $size = "";
    foreach $letter (@letters) {
        $size = $size.$letter;
        $count = $count+1;
        if ($count % 3 == 0 && $count < $len) {
            $size = $size.",";
        }
    }
    return( reverse($size) );
}
